import pandas as pd   
import pickle
from decision_company import read_csv_file, count_unique_values, bind_dataframe, pivot_a_level, fill_missing_values, logical_and, filter_by_condition 

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")   
  
age_column = credit_customers['age'] 
middle_age_condition = logical_and(age_column > 40, age_column < 59)  
middle_age_customers = filter_by_condition(credit_customers, middle_age_condition)  
middle_age_group = bind_dataframe(middle_age_customers, 'age')  
middle_age_counts = count_unique_values(middle_age_group['class'], normalize=True)  
approval_rates_middle_age = fill_missing_values(pivot_a_level(middle_age_counts), value=0)['good']  
 
print(approval_rates_middle_age)
pickle.dump(approval_rates_middle_age,open("./ref_result/approval_rates_middle_age.pkl","wb"))

  